package parser;

/**
 * Grammar non-terminal -- T1a ::= * S
 */
public class T1a implements T1 {
    /**
     * Multiply object.
     */
    private MultToken _mult;

    /**
     * S object.
     */
    private S _s;

    /**
     * Constructor for the T1a grammar non-terminal.
     *
     * @param mult mult object
     * @param s    S object
     */
    public T1a(MultToken mult, S s) {
        _mult = mult;
        _s = s;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _mult.toString() + _s.toString();
    }
}

